# -*- coding: iso-8859-1 -*-

#####################################################################
# Daniel Caldern S.
# CC3501
#####################################################################

# EarthDefender_s.py
# ---------------
# Juego completo,
# incluye sonido
# al presionar enter, cambia la gravedad
# al presionar backspace, los meteoritos se generan mas rpido.
# ---------------

# Implementacin testeada con:
## Python 2.6
## PyOpenGL 3.0.1
## PyGame 1.9.1

#####################################################################

import pygame
from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *
from random import uniform
import math
from Vector2D import *

#####################################################################

class Nave:
    def __init__(self):
        self.r = 30 # "radio" aprox de la nave
        self.p = Vector(0.0,100.0)  # posicion de la nave
        self.sp = 10 # cantidad de ataques especiales
        
    def dibujar(self):
        glPushMatrix()
        
        glTranslatef(self.p.x(),self.p.y(),0.0)
        glColor4f(1.0,1.0,1.0,1.0)

        glBegin(GL_POLYGON)
        
        glVertex2f(0,100)
        glVertex2f(30,0)
        glVertex2f(-30,0)

        glEnd()
        glPopMatrix()

class Meteorito:
    def __init__(self, r, p, v, o, w):
        self.r = r # "radio" aprox del meteorito
        self.p = p # posicion
        self.v = v # velocidad
        self.o = o # orientacion en grados del meteorito.
        self.w = w # velocidad angular del meteorito.
        self.vive = True # marca para poder eliminar ...
        self.rgb=[0.7,0.5,0.04,0.0]

    def mover(self,dt):
        # cinematica,
        # acelera la velocidad.
        self.v=sumar(self.v,ponderar(dt,a))
        # modifica la posicion con la velocidad instantanea.
        self.p=sumar(self.p,ponderar(dt,self.v))
		
        # rotar	
        self.o += self.w * dt
        
    def dibujar(self):
        glPushMatrix()
        
        glTranslatef(self.p.x(),self.p.y(),0.0)
        glScalef(self.r,self.r,0.0)
        glRotatef(self.o,0.0,0.0,1)
        glColor4f(self.rgb[0],self.rgb[1],self.rgb[2],1.0)

        glBegin(GL_POLYGON)
        
        glVertex2f(-143/150.0,-26/150.0)
        glVertex2f(-154/150.0,86/150.0)
        glVertex2f(-66/150.0,167/150.0)
        glVertex2f(142/150.0,110/150.0)
        glVertex2f(175/150.0,-44/150.0)
        glVertex2f(155/150.0,-108/150.0)
        glVertex2f(53/150.0,-108/150.0)
        glVertex2f(-39/150.0,-149/150.0)
        glVertex2f(-162/150.0,-121/150.0)
        
        glEnd()
        glPopMatrix()
		
class Bala:
    def __init__(self, p, v):
        self.r = 5 # "radio" aprox de la bala
        self.p = p
        self.v = v
        self.vive = True # marca para poder eliminar ...

    def mover(self,dt):
        self.v=sumar(self.v,ponderar(dt,a))
        self.p=sumar(self.p,ponderar(dt,self.v))
        
    def dibujar(self):
        glPushMatrix()

        glTranslatef(self.p.x(),self.p.y(),0.0)
        glRotatef(self.v.anguloG(),0.0,0.0,1.0)
        glColor4f(1.0,1.0,0.0,1.0)

        glBegin(GL_POLYGON)

        glVertex2f(0,5.0)
        glVertex2f(10.0,0)
        glVertex2f(0,-5.0)
				
        glEnd()
        glPopMatrix()    

class Tierra:
    def __init__(self):
        self.c = Circulo(800,Vector(w/2,-700),Vector(0,0),[0,0,1],50)
        self.vida = 1000.0
		
    def dibujar(self):
        self.c.dibujar()

    def impactar(self,x):
        self.vida = self.vida-x

        # valor entre 0 y 1.
        # 0 = cero vidas = rojo
        # 1 = 1000 vidas = azul
        p=self.vida/1000.0

        # cambia el color de azul a rojo al disminuir p.
        self.c.rgb=[1-p,self.c.rgb[1],p]

class Circulo:
    def __init__(self, r, p, v, rgb, nt):

        self.r = r
        self.p = p
        self.v = v
        self.rgb = []
        self.rgb.append(rgb[0])
        self.rgb.append(rgb[1])
        self.rgb.append(rgb[2])

        self.t = []

        a=2*math.pi/nt

        for i in range(nt):
            ai=a*i
            self.t.append(VectorPolar(1.0,ai))

        # se guardan los vertices en un arreglo,
        # para no calcularlos en cada iteracion.

    def mover(self,dt):
        self.v=sumar(self.v,ponderar(dt,g))
        self.p=sumar(self.p,ponderar(dt,self.v))
		
    def dibujar(self):
        glPushMatrix()

        glTranslatef(self.p.x(),self.p.y(),0.0)
        glScalef(self.r,self.r,0.0)
        glColor4f(self.rgb[0],self.rgb[1],self.rgb[2],1.0)

        glBegin(GL_POLYGON)

        glVertex4f( 0.0, 0.0, 0.0 , 1.0)

        for v in self.t:
            glVertex4f( v.x(), v.y(), 0.0 , 1.0)

        glVertex4f(self.t[0].x(),self.t[0].y(), 0.0 , 1.0)
				
        glEnd()
        glPopMatrix()

#####################################################################

def estanChocando(c1,c2):
    return distancia(c1.p,c2.p) < (c1.r + c2.r)

def fuera(c):
    # elimina el objeto c si es que esta fuera de la pantalla.
    if c.p.x()>w+300 or c.p.x()<-300 or c.p.y()>h+300 or (c.p.y()<100 and c.p.x()<0 and c.p.x()>w):
        c.vive = False

def impacto(tierra,m):
    # si hay impacto del meteorito con la tierra, la danna y elimina el meteorito
    if m.p.y()<100 and m.p.x()>0 and m.p.x()<w:
        tierra.impactar(10.0+40.0*(m.r-Rmin)/(Rmax-Rmin))
        m.vive = False
    
#####################################################################

def crearMeteorito():
    # crea un meteorito aleatorio
    r=uniform(Rmin,Rmax)
    p=Vector(uniform(0,w),h+Rmax)
    v=Vector(0,0)
    o=uniform(0,360)
    v_ang=uniform(-5.0,5.0)
    return Meteorito(r,p,v,o,v_ang)

def limpiar(cs):
    # saca los objetos destruidos del contenedor cs.
    n=len(cs)
    aux=[]
    for i in range(n):
        c=cs.pop(0)
        if c.vive:
            aux.append(c)
    for a in aux:
        cs.append(a)

def accion(nave,ms,bs,dt):
    # limpia la pantalla
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)

    # dibuja la tierra
    tierra.dibujar()

    # itera los meteoritos
    for m in ms:
        # mueve el meteorito
        m.mover(dt/60.0)

        # chequea si estan afuera de la pantalla, los elimina de ser asi.
        fuera(m)

        # dibuja el meteorito
        m.dibujar()

        # chequea impactos con la tierra y actua en concecuencia.
        impacto(tierra,m)

    # itera las balas
    for b in bs:
        b.mover(dt/60.0)
        fuera(b)
        b.dibujar()

        # chequea colisiones con los meteoritos
        for m in ms:
            # de haber colision, destruye ambos.
            if estanChocando(m,b):
                m.vive = False
                b.vive = False				

    #elimina las balas y meteoritos.
    limpiar(bs)
    limpiar(ms)

    # dibuja la nave
    nave.dibujar()

    glLoadIdentity()

#####################################################################
# Funciones de graficos
#####################################################################

def init_pygame((w,h), title=""):
    pygame.init()
    pygame.display.set_mode((w,h), OPENGL|DOUBLEBUF)
    pygame.display.set_caption(title)
	
def init():
    glClearColor(0.0, 0.0, 0.0, 0.0)
    glClearDepth(1.0)
    glDisable(GL_DEPTH_TEST)
    glShadeModel(GL_SMOOTH)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)
    glEnable (GL_BLEND)
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
    glHint (GL_LINE_SMOOTH_HINT, GL_NICEST)

def reshape((width, height)):
    if height == 0:
        height = 1
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluOrtho2D(0.0, width, 0.0, height)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
	
def init_opengl((w,h)):
    init()
    reshape((w,h))

#####################################################################
# Programa principal
#####################################################################

def main(argv):

    # imprime en consola
    print 'Earth Defender'

    global h,w,a,tierra,Rmin,Rmax,nave,run,n

    Rmax = 200.0 # "radio" maximo meteoritos
    Rmin = 30.0 # "radio" minimo meteoritos
    w = 900 # ancho
    h = 600 # alto
    t = 0   # tiempo de conteo para generar meteoritos
	
    # si se desea utilizar argumentos del programa...
    # if len(argv) > 1:
        # var1 = argv[1]
        # var2 = int(argv[2])

    v0=Vector(0,30)    # velocidad balas
    a=Vector(0.0,-0.5) # aceleracin de gravedad
    T=600 # periodo de aparicion de meteoritos

    ms=[] # contenedor de meteoritos
    bs=[] # contenedor de balas
    nave=Nave()
    tierra=Tierra()

    # inicializando ...
    init_pygame((w,h),"Earth Defender")
    init_opengl((w,h))

    # sonidos
    sound_shoot = pygame.mixer.Sound("laser.wav")
    sound_shoot.set_volume(0.2)
	
    # msica de fondo
    pygame.mixer.music.load("background.mp3")
    pygame.mixer.music.play(-1,0.0)


    # medida de tiempo inicial
    t0=pygame.time.get_ticks()

    run=True
    while run:
        # 0: CONTROL DEL TIEMPO
        t1 = pygame.time.get_ticks()	# tiempo actual
        dt = (t1 - t0)					# diferencial de tiempo asociado a la iteracin
        t0 = t1							# actualizar tiempo inicial para siguiente iteracin
		
		
        for event in pygame.event.get():
            mouse_pos=pygame.mouse.get_pos()
            nave.p=Vector(mouse_pos[0],100)

            # disparar
            if event.type == MOUSEBUTTONDOWN:
                bs.append(Bala(nave.p,v0))
                sound_shoot.play()

            # cerrar
            if event.type == QUIT:
                run=False

            if event.type == KEYDOWN:
                # ataque especial
                if event.key == K_SPACE:
                    if nave.sp-1>=0:
                        bs.append(Bala(nave.p,v0))
                        bs.append(Bala(nave.p,rotar(v0,math.pi/12)))
                        bs.append(Bala(nave.p,rotar(v0,-math.pi/12)))
                        bs.append(Bala(nave.p,rotar(v0,math.pi/6)))
                        bs.append(Bala(nave.p,rotar(v0,-math.pi/6)))
                        bs.append(Bala(nave.p,rotar(v0,math.pi/4)))
                        bs.append(Bala(nave.p,rotar(v0,-math.pi/4)))
                        nave.sp=nave.sp-1
				
                # cambia la aceleracin del nivel
                if event.key == K_RETURN:
                    a = Vector(uniform(-0.5,0.5),uniform(-1.0,0))
                    print "a = ", a.cartesianas()
                    
                # genera meteoritos ms rpido
                if event.key == K_BACKSPACE:
                    T -= T*0.1
                    print "T = ",T
				
                # cerrar
                if event.key == K_ESCAPE:
                    run = False
					 
        # si se acaban las vidas termina el programa.
        if tierra.vida <= 0:
            print 'GAME OVER'
            run = False

        # efecua las acciones necesarias de manera proporcional a dt
        accion(nave,ms,bs,dt)

        # si supero el periodo de creacion de meteoritos
        # creo un meteorito, y reinicio el tiempo
        t=t+dt
        if t>T:
            t=t-T
            ms.append(crearMeteorito())

        # pone el dibujo en la pantalla
        pygame.display.flip()
        # ajusta para trabajar a 30 fps.
        pygame.time.wait(1000/30)

    # termina pygame (cerrar ventana)
    pygame.quit()

if __name__ == "__main__":
    import sys
    # sys.argv es una lista de strings con los argumentos que se le dan al interprete,
    # es decir, si llamamos a
    # python EarthDefender_s.py 3 2
    # entonces
    # sys.argv = ["EarthDefender_s.py","3","2"]
    # luego
    # sys.argv[0] = "EarthDefender_s.py"
    # sys.argv[1] = "3"
    # sys.argv[2] = "2"
    main(sys.argv)
    
#####################################################################
